********************************************************************************
** Table 1-2, Appendix Table 6, 8-10: Analysis Sample, Fixed Demographic weight
********************************************************************************

clear
local projectfolder "C:\Users\worri\Dropbox\Poverty\COVID19\"
cd `projectfolder'
use Monthly_Poverty_0520.dta 

gen yr_month=year*100+month   
keep if yr_month>=202001
** replace asecflag 2 => asecflag . 
replace asecflag=. if asecflag==2 
** drop irrelevant variables
drop month hflag qinc* qoinc* cpsid cpsidp durunemp whyunemp whyabsnt wnlook wkstat wksworkorg occ ind classwkr earnwt earnweek inctot

********************************************************************************
******   Construct a family unit variable for Poverty measures, famnum    ******
** For the poverty measure, a primary family and realted family is considered as one family

/* Assign 1 to primary+realted families */
gen famnum = ftype==1|ftype==3 

/* Assign 2-4 to unrelated subfamilies */ 
sort yr_month asecflag serial ftype pernum
* Each subfamily has a reference person  (famrel==1)
* Calculate # subfamilies in a household (Max 3 in this sample period)
bysort yr_month asecflag serial: egen tot_subfam = sum(ftype==4 & famrel==1)
tab tot_subfam if ftype==4 
sort yr_month asecflag serial ftype famrel
bysort yr_month asecflag serial ftype: gen subfamnum = sum(famrel==1)
tab subfamnum if ftype==4 
* Assign 2-4 to the 1st-3rd unrelated subfamily
replace famnum= subfamnum+1 if ftype==4 
drop subfamnum 


/* Assign 5-20 to non-family members (ftype=1,2 or famrel=0) */
* Calculate # non-family members within a household (Max 16 in this sample period)
bysort yr_month asecflag serial: gen non_fam = sum(famrel==0) 
tab non_fam 
* Assign 5-20 to the 1st-20th non-family member. 
replace famnum= non_fam+4 if famrel==0  
drop non_fam

* Construct demographic variables related to the poverty threshold 
* 1) family size
bysort yr_month asecflag serial famnum: gen fam_size = _N
* 2) related children under age 18 (excluding HH head or spouse)
bysort yr_month asecflag serial famnum: egen nchild = sum(age<18 & relate>=301)
* 3) the head is elderly (>=65)
bysort yr_month asecflag serial famnum: egen head_elderly = max(age>=65 & relate==101)
* 4) a few cases where all members are children -> change to one adult w/ two children 
replace nchild=nchild-1 if fam_size==nchild


* Assign poverty thresholds from the ASEC data to the relevent dem. group in the Monthly CPS
merge m:1 year fam_size nchild head_elderly using pov_thresh
keep if _merge==3
drop _merge

* Merge with the imputed family income data 
merge m:1 yr_month asecflag serial using impute
keep if _merge==3
drop _merge

********************************************************************************
* Scale variables
gen scale=((fam_size-nchild+.7*nchild)^.7)

* Construct variables for subgroup analysis 

*1) Full sample
gen gr1=1

*2) Age subgroup
gen gr2= age<18
replace gr2 = 2 if age>=18 & age<65   
replace gr2 = 3 if age>=65

*3) Race subgroup
gen gr3 = race==100             // white   
replace gr3 = 2 if race==200    // black   
replace gr3 = 3 if race!=100 & race!=200  

*4) gender subgroup
gen gr4 = sex==1
replace gr4 = 2 if gr4==0

*5) Education subgroup 
*Head's education
bysort yr_month asecflag serial famnum: egen head_hs_less = max(relate==101 & edu<=73)
gen gr5 = head_hs_less==1
replace gr5 = 2 if head_hs_less==0

merge m:1 statefip using st_covid.dta
drop _merge

********************************************************************************
*************          Combine with the State COVID info         ***************
*6) COVID death rate
gen gr6 = high_dr==1
replace gr6 = 2 if gr6==0
*7) Stay at Home order
gen gr7= early_sh==1
replace gr7 = 2 if gr7==0
*8) State of Emergency order
gen gr8 = early_soe==1
replace gr8 = 2 if gr8==0
*9) UI recipiency rate
gen gr9 = high_ui==1
replace gr9 = 2 if gr9==0


********************************************************************************
* Missing incomes or CPS-imputed income 
gen miss_inc = (faminc>=995 & faminc<=999)|(qfaminc>0 & qfaminc!=.)

*** Restrict the sample to householder's family 
bysort yr_month asecflag serial famnum: egen hfam = sum(relate==101) 
keep if hfam==1

*** Restrict the sample to individuals in the 1st or 5th month interview
keep if mish==1|mish==5

*** Restrict the sample to individuals with non-imputed income 
keep if miss_inc!=1


********************************************************************************
** Use fixed demographic weight since March 2020
merge 1:1 yr_month asecflag serial pernum using fixedwgt.dta
drop _merge
replace wtfinl = fixedwgt if yr_month>=202003

********************************************************************************
***  Poverty, Income, Employment variables for 1st and 5th month interview   ***

forvalues n=1/1 {
gen pov`n'= ifam_inc<pov_thresh
gen ifam_inc`n'=ifam_inc
}
merge m:1 yr_month using PCE
keep if _merge==3
drop _merge
** equivalent scale adjustment & 2 adults and 2 children
replace ifam_inc1 = PCE*2.355*ifam_inc1/scale   



********************************************************************************
*************               Calculate Standard Errors              *************


* Full sample
forvalues m = 1/1 {
forvalues i = 1/1 {
forvalues mo = 1/6 {
di `mo'
preserve
keep yr_month serial wtfinl gr* ifam_inc* pov* 
egen ym = group(yr_month)
keep if ym==`mo' & gr`i'==1
local num = `mo'+1


** Poverty Rate
reg pov`m' [w=wtfinl], cluster(serial)
putexcel set Table1-2App.T6&8-10.xlsx, sheet(gr1) modify
putexcel A`num' = yr_month
putexcel B`num' = _b[_cons]
putexcel C`num' = _se[_cons]
putexcel D`num' = `e(N)'
putexcel K`num' = `e(N)'
putexcel R`num' = `e(N)'
putexcel Y`num' = `e(N)'

** Income Percentiles
replace wtfinl= round(wtfinl)
qreg2 ifam_inc`m' [w=wtfinl], quantile(.25) 
putexcel H`num' = yr_month
putexcel I`num' = _b[_cons]
putexcel J`num' = _se[_cons]
qreg2 ifam_inc`m' [w=wtfinl], quantile(.50) 
putexcel O`num' = yr_month
putexcel P`num' = _b[_cons]
putexcel Q`num' = _se[_cons]
qreg2 ifam_inc`m' [w=wtfinl], quantile(.75) 
putexcel V`num' = yr_month
putexcel W`num' = _b[_cons]
putexcel X`num' = _se[_cons]
restore
}
putexcel A1 = "Table1. Poverty"
putexcel H1 = "Table2. 25thpct"
putexcel O1 = "App.T8. 50thpct"
putexcel V1 = "App.T9. 75thpct"
}
}

* Subgroup with two categories (GROUP 1)
forvalues m = 1/1 {
forvalues i = 2/5 {
forvalues mo = 1/6 {
di `mo'
preserve
keep yr_month serial wtfinl gr* ifam_inc* pov* 
egen ym = group(yr_month)
keep if ym==`mo' & gr`i'==1
local num = `mo'+1


** Poverty Rate
reg pov`m' [w=wtfinl], cluster(serial)
putexcel set Table1-2App.T6&8-10.xlsx, sheet(gr`i') modify
putexcel A`num' = yr_month
putexcel B`num' = _b[_cons]
putexcel C`num' = _se[_cons]

** Income Percentiles
replace wtfinl= round(wtfinl)
qreg2 ifam_inc`m' [w=wtfinl], quantile(.25) 
putexcel H`num' = yr_month
putexcel I`num' = _b[_cons]
putexcel J`num' = _se[_cons]
qreg2 ifam_inc`m' [w=wtfinl], quantile(.50) 
putexcel O`num' = yr_month
putexcel P`num' = _b[_cons]
putexcel Q`num' = _se[_cons]
qreg2 ifam_inc`m' [w=wtfinl], quantile(.75) 
putexcel V`num' = yr_month
putexcel W`num' = _b[_cons]
putexcel X`num' = _se[_cons]
restore
}
}
putexcel A1 = "Table1. Poverty"
putexcel H1 = "Table2. 25thpct"
putexcel O1 = "App.T8. 50thpct"
putexcel V1 = "App.T9. 75thpct"
}



* Subgroup with two categories (GROUP 1), state group
forvalues m = 1/1 {
forvalues i = 6/9 {
forvalues mo = 1/6 {
di `mo'
preserve
keep yr_month serial wtfinl gr* ifam_inc* pov* 
egen ym = group(yr_month)
keep if ym==`mo' & gr`i'==1
local num = `mo'+1

** Poverty Rate
reg pov`m' [w=wtfinl], cluster(serial)
putexcel set Table1-2App.T6&8-10.xlsx, sheet(gr`i') modify
putexcel A`num' = yr_month
putexcel B`num' = _b[_cons]
putexcel C`num' = _se[_cons]

** Income Percentiles
replace wtfinl= round(wtfinl)
qreg2 ifam_inc`m' [w=wtfinl], quantile(.25)
putexcel H`num' = yr_month 
putexcel I`num' = _b[_cons]
putexcel J`num' = _se[_cons]
restore
}
}
putexcel A1 = "App.T6. Poverty"
putexcel H1 = "App.T10. 25thpct"
}


* Subgroup with two categories (GROUP 2)
forvalues m = 1/1 {
forvalues i = 2/5 {
forvalues mo = 1/6 {
preserve
keep yr_month serial wtfinl gr* ifam_inc* pov* 
egen ym = group(yr_month)
keep if ym==`mo' & gr`i'==2
local num = `mo'+1


** Poverty Rate
reg pov`m' [w=wtfinl], cluster(serial)
putexcel set Table1-2App.T6&8-10.xlsx, sheet(gr`i') modify
putexcel D`num' = _b[_cons]
putexcel E`num' = _se[_cons]

** Income Percentiles
replace wtfinl= round(wtfinl)
qreg2 ifam_inc`m' [w=wtfinl], quantile(.25) 
putexcel K`num' = _b[_cons]
putexcel L`num' = _se[_cons]
qreg2 ifam_inc`m' [w=wtfinl], quantile(.50) 
putexcel R`num' = _b[_cons]
putexcel S`num' = _se[_cons]
qreg2 ifam_inc`m' [w=wtfinl], quantile(.75) 
putexcel Y`num' = _b[_cons]
putexcel Z`num' = _se[_cons]
restore
}
putexcel A1 = "Table1. Poverty"
putexcel H1 = "Table2. 25thpct"
putexcel O1 = "App.T8. 50thpct"
putexcel V1 = "App.T9. 75thpct"
}
}



* Subgroup with two categories (GROUP 2), state group
forvalues m = 1/1 {
forvalues i = 6/9 {
forvalues mo = 1/6 {
preserve
keep yr_month serial wtfinl gr* ifam_inc* pov* 
egen ym = group(yr_month)
keep if ym==`mo' & gr`i'==2
local num = `mo'+1

** Poverty Rate
reg pov`m' [w=wtfinl], cluster(serial)
putexcel set Table1-2App.T6&8-10.xlsx, sheet(gr`i') modify
putexcel D`num' = _b[_cons]
putexcel E`num' = _se[_cons]

** Income Percentiles
replace wtfinl= round(wtfinl)
qreg2 ifam_inc`m' [w=wtfinl], quantile(.25) 
putexcel K`num' = _b[_cons]
putexcel L`num' = _se[_cons]
restore
}
putexcel A1 = "App.T6. Poverty"
putexcel H1 = "App.T10. 25thpct"
}
}



* Subgroup with three categories
forvalues m = 1/1 {
foreach i in 2 3 {
forvalues mo = 1/6 {
preserve
keep yr_month serial wtfinl gr* ifam_inc* pov* 
egen ym = group(yr_month)
keep if ym==`mo' & gr`i'==3
local num = `mo'+1

** Poverty Rate
reg pov`m' [w=wtfinl], cluster(serial)
putexcel set Table1-2App.T6&8-10.xlsx, sheet(gr`i') modify
putexcel F`num' = _b[_cons]
putexcel G`num' = _se[_cons]

** Income Percentiles
replace wtfinl= round(wtfinl)
qreg2 ifam_inc`m' [w=wtfinl], quantile(.25) 
putexcel M`num' = _b[_cons]
putexcel N`num' = _se[_cons]
qreg2 ifam_inc`m' [w=wtfinl], quantile(.50) 
putexcel T`num' = _b[_cons]
putexcel U`num' = _se[_cons]
qreg2 ifam_inc`m' [w=wtfinl], quantile(.75) 
putexcel AA`num' = _b[_cons]
putexcel AB`num' = _se[_cons]
restore
}
putexcel A1 = "Table1. Poverty"
putexcel H1 = "Table2. 25thpct"
putexcel O1 = "App.T8. 50thpct"
putexcel V1 = "App.T9. 75thpct"
}
}

********************************************************************************
** Pre- vs. Post- COVID19 period
drop if yr_month==202003
replace yr_month=202012 if yr_month==202001|yr_month==202002
replace yr_month=202046 if yr_month==202004|yr_month==202005|yr_month==202006

* Full sample
forvalues m = 1/1 {
forvalues i = 1/1 {
forvalues bimo = 1/2 {
preserve
keep yr_month serial wtfinl gr* ifam_inc* pov* 
egen ym = group(yr_month)
keep if ym==`bimo' & gr`i'==1
local num = `bimo'+7

** Poverty Rate
reg pov`m' [w=wtfinl], cluster(serial)
putexcel set Table1-2App.T6&8-10.xlsx, sheet(gr1) modify
putexcel A`num' = yr_month
putexcel B`num' = _b[_cons]
putexcel C`num' = _se[_cons]
putexcel D`num' = `e(N)'
putexcel K`num' = `e(N)'
putexcel R`num' = `e(N)'
putexcel Y`num' = `e(N)'

** Income Percentiles
replace wtfinl= round(wtfinl)
qreg2 ifam_inc`m' [w=wtfinl], quantile(.25) 
putexcel H`num' = yr_month
putexcel I`num' = _b[_cons]
putexcel J`num' = _se[_cons]
qreg2 ifam_inc`m' [w=wtfinl], quantile(.50) 
putexcel O`num' = yr_month
putexcel P`num' = _b[_cons]
putexcel Q`num' = _se[_cons]
qreg2 ifam_inc`m' [w=wtfinl], quantile(.75) 
putexcel V`num' = yr_month
putexcel W`num' = _b[_cons]
putexcel X`num' = _se[_cons]
restore
}
putexcel A1 = "Table1. Poverty"
putexcel H1 = "Table2. 25thpct"
putexcel O1 = "App.T8. 50thpct"
putexcel V1 = "App.T9. 75thpct"
}
}


* Subgroup with two categories (GROUP 1)
forvalues m = 1/1 { 
forvalues i = 2/5 {
forvalues bimo = 1/2 {
preserve
keep yr_month serial wtfinl gr* ifam_inc* pov* 
egen ym = group(yr_month)
keep if ym==`bimo' & gr`i'==1
local num = `bimo'+7

** Poverty Rate
reg pov`m' [w=wtfinl], cluster(serial)
putexcel set Table1-2App.T6&8-10.xlsx, sheet(gr`i') modify
putexcel A`num' = yr_month
putexcel B`num' = _b[_cons]
putexcel C`num' = _se[_cons]

** Income Percentiles
replace wtfinl= round(wtfinl)
qreg2 ifam_inc`m' [w=wtfinl], quantile(.25) 
putexcel H`num' = yr_month
putexcel I`num' = _b[_cons]
putexcel J`num' = _se[_cons]
qreg2 ifam_inc`m' [w=wtfinl], quantile(.50) 
putexcel O`num' = yr_month
putexcel P`num' = _b[_cons]
putexcel Q`num' = _se[_cons]
qreg2 ifam_inc`m' [w=wtfinl], quantile(.75) 
putexcel V`num' = yr_month
putexcel W`num' = _b[_cons]
putexcel X`num' = _se[_cons]
restore
}
putexcel A1 = "Table1. Poverty"
putexcel H1 = "Table2. 25thpct"
putexcel O1 = "App.T8. 50thpct"
putexcel V1 = "App.T9. 75thpct"
}
}


* Subgroup with two categories (GROUP 1), state group
forvalues m = 1/1 { 
forvalues i = 6/9 {
forvalues bimo = 1/2 {
preserve
keep yr_month serial wtfinl gr* ifam_inc* pov* 
egen ym = group(yr_month)
keep if ym==`bimo' & gr`i'==1
local num = `bimo'+7

** Poverty Rate
reg pov`m' [w=wtfinl], cluster(serial)
putexcel set Table1-2App.T6&8-10.xlsx, sheet(gr`i') modify
putexcel A`num' = yr_month
putexcel B`num' = _b[_cons]
putexcel C`num' = _se[_cons]

** Income Percentiles
replace wtfinl= round(wtfinl)
qreg2 ifam_inc`m' [w=wtfinl], quantile(.25) 
putexcel H`num' = yr_month
putexcel I`num' = _b[_cons]
putexcel J`num' = _se[_cons]
restore
}
putexcel A1 = "App.T6. Poverty"
putexcel H1 = "App.T10. 25thpct"
}
}



* Subgroup with two categories (GROUP 2)
forvalues m = 1/1 { 
forvalues i = 2/5 {
forvalues bimo = 1/2 {
preserve
keep yr_month serial wtfinl gr* ifam_inc* pov* 
egen ym = group(yr_month)
keep if ym==`bimo' & gr`i'==2
local num = `bimo'+7

** Poverty Rate
reg pov`m' [w=wtfinl], cluster(serial)
putexcel set Table1-2App.T6&8-10.xlsx, sheet(gr`i') modify
putexcel D`num' = _b[_cons]
putexcel E`num' = _se[_cons]

** Income Percentiles
replace wtfinl= round(wtfinl)
qreg2 ifam_inc`m' [w=wtfinl], quantile(.25) 
putexcel K`num' = _b[_cons]
putexcel L`num' = _se[_cons]
qreg2 ifam_inc`m' [w=wtfinl], quantile(.50) 
putexcel R`num' = _b[_cons]
putexcel S`num' = _se[_cons]
qreg2 ifam_inc`m' [w=wtfinl], quantile(.75) 
putexcel Y`num' = _b[_cons]
putexcel Z`num' = _se[_cons]
restore
}
putexcel A1 = "Table1. Poverty"
putexcel H1 = "Table2. 25thpct"
putexcel O1 = "App.T8. 50thpct"
putexcel V1 = "App.T9. 75thpct"
}
}


* Subgroup with two categories (GROUP 2), state group
forvalues m = 1/1 { 
forvalues i = 6/9 {
forvalues bimo = 1/2 {
preserve
keep yr_month serial wtfinl gr* ifam_inc* pov* 
egen ym = group(yr_month)
keep if ym==`bimo' & gr`i'==2
local num = `bimo'+7

** Poverty Rate
reg pov`m' [w=wtfinl], cluster(serial)
putexcel set Table1-2App.T6&8-10.xlsx, sheet(gr`i') modify
putexcel D`num' = _b[_cons]
putexcel E`num' = _se[_cons]

** Income Percentiles
replace wtfinl= round(wtfinl)
qreg2 ifam_inc`m' [w=wtfinl], quantile(.25) 
putexcel K`num' = _b[_cons]
putexcel L`num' = _se[_cons]
restore
}
putexcel A1 = "App.T6. Poverty"
putexcel H1 = "App.T10. 25thpct"
}
}



* Subgroup with three categories
forvalues m = 1/1 {
foreach i in 2 3 {
forvalues bimo = 1/2 {
preserve
keep yr_month serial wtfinl gr* ifam_inc* pov* 
egen ym = group(yr_month)
keep if ym==`bimo' & gr`i'==3
local num = `bimo'+7

** Poverty Rate
reg pov`m' [w=wtfinl], cluster(serial)
putexcel set Table1-2App.T6&8-10.xlsx, sheet(gr`i') modify
putexcel F`num' = _b[_cons]
putexcel G`num' = _se[_cons]

** Income Percentiles
replace wtfinl= round(wtfinl)
qreg2 ifam_inc`m' [w=wtfinl], quantile(.25) 
putexcel M`num' = _b[_cons]
putexcel N`num' = _se[_cons]
qreg2 ifam_inc`m' [w=wtfinl], quantile(.50) 
putexcel T`num' = _b[_cons]
putexcel U`num' = _se[_cons]
qreg2 ifam_inc`m' [w=wtfinl], quantile(.75) 
putexcel AA`num' = _b[_cons]
putexcel AB`num' = _se[_cons]
restore
}
putexcel A1 = "Table1. Poverty"
putexcel H1 = "Table2. 25thpct"
putexcel O1 = "App.T8. 50thpct"
putexcel V1 = "App.T9. 75thpct"
}
}


********************************************************************************
** Table 1
import excel "`projectfolder'Table1-2App.T6&8-10.xlsx", sheet("gr1") cellrange(A1:G9) firstrow clear
forvalues i = 2/5 { 
preserve
import excel "`projectfolder'Table1-2App.T6&8-10.xlsx", sheet("gr`i'") cellrange(A1:G9) firstrow clear
foreach var in B C D E F G {
	rename `var' `var'`i'
	}
tempfile gr`i'
save `gr`i''
restore
merge 1:1 Table1Poverty using `gr`i''
drop _merge
}
xpose, clear
egen miss = rowmiss(_all)
drop if miss>0
drop miss
gen v9 = v8-v7 if _n==2|_n==5|_n==7|_n==9|_n==11|_n==13|_n==15|_n==17|_n==19|_n==21|_n==23
replace v9 = sqrt(v8^2+v7^2) if _n==3|_n==6|_n==8|_n==10|_n==12|_n==14|_n==16|_n==18|_n==20|_n==22|_n==24
drop v7 v8
export excel using Table1.xlsx, keepcellfmt replace

********************************************************************************
** Table 2
import excel "`projectfolder'Table1-2App.T6&8-10.xlsx", sheet("gr1") cellrange(H1:N9) firstrow clear
forvalues i = 2/5 { 
preserve
import excel "`projectfolder'Table1-2App.T6&8-10.xlsx", sheet("gr`i'") cellrange(H1:N9) firstrow clear
foreach var in I J K L M N {
	rename `var' `var'`i'
	}
tempfile gr`i'
save `gr`i''
restore
merge 1:1 Table225thpct using `gr`i''
drop _merge
}
xpose, clear
egen miss = rowmiss(_all)
drop if miss>0
drop miss
local pointest _n==2|_n==5|_n==7|_n==9|_n==11|_n==13|_n==15|_n==17|_n==19|_n==21|_n==23
local sterr  _n==3|_n==6|_n==8|_n==10|_n==12|_n==14|_n==16|_n==18|_n==20|_n==22|_n==24
gen v9 = v8-v7 if `pointest'
replace v9 = sqrt(v8^2+v7^2) if `sterr'
drop v7 v8
gen id = _n*2
drop if `sterr'
preserve
import excel "`projectfolder'Table2_BSE.xls", firstrow clear
drop gr
rename (p251 p252 p253 p254 p255 p256 p257) (v1 v2 v3 v4 v5 v6 v9)
gen id = _n*4+4
replace id=6 if id==8
tempfile bse
save `bse'
restore
append using `bse'
sort id
drop id

export excel using Table2.xlsx, keepcellfmt replace


********************************************************************************
** Appendix Table 6
import excel "`projectfolder'Table1-2App.T6&8-10.xlsx", sheet("gr6") cellrange(A1:E9) firstrow clear
forvalues i = 7/9 { 
preserve
import excel "`projectfolder'Table1-2App.T6&8-10.xlsx", sheet("gr`i'") cellrange(A1:E9) firstrow clear
foreach var in B C D E {
	rename `var' `var'`i'
	}
tempfile gr`i'
save `gr`i''
restore
merge 1:1 AppT6Poverty using `gr`i''
drop _merge
}
xpose, clear
egen miss = rowmiss(_all)
drop if miss>0
drop miss
gen v9 = v8-v7 if _n==2|_n==4|_n==6|_n==8|_n==10|_n==12|_n==14|_n==16    
replace v9 = sqrt(v8^2+v7^2) if _n==3|_n==5|_n==7|_n==9|_n==11|_n==13|_n==15|_n==17
drop v7 v8
export excel using App.T6.xlsx, keepcellfmt replace


********************************************************************************
** Appendix Table 10
import excel "`projectfolder'Table1-2App.T6&8-10.xlsx", sheet("gr6") cellrange(H1:L9) firstrow clear
forvalues i = 7/9 { 
preserve
import excel "`projectfolder'Table1-2App.T6&8-10.xlsx", sheet("gr`i'") cellrange(H1:L9) firstrow clear
foreach var in I J K L {
	rename `var' `var'`i'
	}
tempfile gr`i'
save `gr`i''
restore
merge 1:1 AppT1025thpct using `gr`i''
drop _merge
}
xpose, clear
egen miss = rowmiss(_all)
drop if miss>0
drop miss
local pointest _n==2|_n==4|_n==6|_n==8|_n==10|_n==12|_n==14|_n==16    
local sterr  _n==3|_n==5|_n==7|_n==9|_n==11|_n==13|_n==15|_n==17
gen v9 = v8-v7 if `pointest'
replace v9 = sqrt(v8^2+v7^2) if `sterr'
drop v7 v8
gen id = _n*2
drop if `sterr'
preserve
import excel "`projectfolder'App.T10_BSE.xls", firstrow clear
drop gr
rename (p251 p252 p253 p254 p255 p256 p257) (v1 v2 v3 v4 v5 v6 v9)
gen id = _n*4+2
replace id=6 if id==8
tempfile bse
save `bse'
restore
append using `bse'
sort id
drop id
export excel using App.T10.xlsx, keepcellfmt replace


********************************************************************************
** Appendix Table 8
import excel "`projectfolder'Table1-2App.T6&8-10.xlsx", sheet("gr1") cellrange(O1:U9) firstrow clear
forvalues i = 2/5 { 
preserve
import excel "`projectfolder'Table1-2App.T6&8-10.xlsx", sheet("gr`i'") cellrange(O1:U9) firstrow clear
foreach var in P Q R S T U {
	rename `var' `var'`i'
	}
tempfile gr`i'
save `gr`i''
restore
merge 1:1 AppT850thpct using `gr`i''
drop _merge
}
xpose, clear
egen miss = rowmiss(_all)
drop if miss>0
drop miss
local pointest _n==2|_n==5|_n==7|_n==9|_n==11|_n==13|_n==15|_n==17|_n==19|_n==21|_n==23
local sterr  _n==3|_n==6|_n==8|_n==10|_n==12|_n==14|_n==16|_n==18|_n==20|_n==22|_n==24
gen v9 = v8-v7 if `pointest'
replace v9 = sqrt(v8^2+v7^2) if `sterr'
drop v7 v8
gen id = _n*2
drop if `sterr'
preserve
import excel "`projectfolder'App.T8_BSE.xls", firstrow clear
drop gr
rename (p501 p502 p503 p504 p505 p506 p507) (v1 v2 v3 v4 v5 v6 v9)
gen id = _n*4+4
replace id=6 if id==8
tempfile bse
save `bse'
restore
append using `bse'
sort id
drop id
export excel using App.T8.xlsx, keepcellfmt replace


********************************************************************************
** Appendix Table 9
import excel "`projectfolder'Table1-2App.T6&8-10.xlsx", sheet("gr1") cellrange(V1:Y9) firstrow clear
forvalues i = 2/3 { 
preserve
import excel "`projectfolder'Table1-2App.T6&8-10.xlsx", sheet("gr`i'") cellrange(V1:AB9) firstrow clear
foreach var in W X Y Z AA AB {
	rename `var' `var'`i'
	}
tempfile gr`i'
save `gr`i''
restore
merge 1:1 AppT975thpct using `gr`i''
drop _merge
}
forvalues i = 4/5 { 
preserve
import excel "`projectfolder'Table1-2App.T6&8-10.xlsx", sheet("gr`i'") cellrange(V1:Z9) firstrow clear
foreach var in W X Y Z {
	rename `var' `var'`i'
	}
tempfile gr`i'
save `gr`i''
restore
merge 1:1 AppT975thpct using `gr`i''
drop _merge
}

xpose, clear
egen miss = rowmiss(_all)
drop if miss>0
drop miss
local pointest _n==2|_n==5|_n==7|_n==9|_n==11|_n==13|_n==15|_n==17|_n==19|_n==21|_n==23
local sterr  _n==3|_n==6|_n==8|_n==10|_n==12|_n==14|_n==16|_n==18|_n==20|_n==22|_n==24
gen v9 = v8-v7 if `pointest'
replace v9 = sqrt(v8^2+v7^2) if `sterr'
drop v7 v8
gen id = _n*2
drop if `sterr'
preserve
import excel "`projectfolder'App.T9_BSE.xls", firstrow clear
drop gr
rename (p751 p752 p753 p754 p755 p756 p757) (v1 v2 v3 v4 v5 v6 v9)
gen id = _n*4+4
replace id=6 if id==8
tempfile bse
save `bse'
restore
append using `bse'
sort id
drop id
export excel using App.T9.xlsx, keepcellfmt replace




********************************************************************************
** App.T5&7: 5th month interview, Original weight
********************************************************************************

clear
local projectfolder "C:\Users\worri\Dropbox\Poverty\COVID19\"
cd `projectfolder'
use Monthly_Poverty_0520.dta 

gen yr_month=year*100+month   
keep if yr_month>=202001
** replace asecflag 2 => asecflag . 
replace asecflag=. if asecflag==2 
** drop irrelevant variables
drop month hflag qinc* qoinc* cpsid cpsidp durunemp whyunemp whyabsnt wnlook wkstat wksworkorg occ ind classwkr earnwt earnweek inctot

********************************************************************************
******   Construct a family unit variable for Poverty measures, famnum    ******
** For the poverty measure, a primary family and related family is considered as one family

/* Assign 1 to primary+realted families */
gen famnum = ftype==1|ftype==3 

/* Assign 2-4 to unrelated subfamilies */ 
sort yr_month asecflag serial ftype pernum
* Each subfamily has a reference person  (famrel==1)
* Calculate # subfamilies in a household (Max 3 in this sample period)
bysort yr_month asecflag serial: egen tot_subfam = sum(ftype==4 & famrel==1)
tab tot_subfam if ftype==4 
sort yr_month asecflag serial ftype famrel
bysort yr_month asecflag serial ftype: gen subfamnum = sum(famrel==1)
tab subfamnum if ftype==4 
* Assign 2-4 to the 1st-3rd unrelated subfamily
replace famnum= subfamnum+1 if ftype==4 
drop subfamnum 


/* Assign 5-20 to non-family members (ftype=1,2 or famrel=0) */
* Calculate # non-family members within a household (Max 16 in this sample period)
bysort yr_month asecflag serial: gen non_fam = sum(famrel==0) 
tab non_fam 
* Assign 5-20 to the 1st-20th non-family member. 
replace famnum= non_fam+4 if famrel==0  
drop non_fam

* Construct demographic variables related to the poverty threshold 
* 1) family size
bysort yr_month asecflag serial famnum: gen fam_size = _N
* 2) related children under age 18 (excluding HH head or spouse)
bysort yr_month asecflag serial famnum: egen nchild = sum(age<18 & relate>=301)
* 3) the head is elderly (>=65)
bysort yr_month asecflag serial famnum: egen head_elderly = max(age>=65 & relate==101)
* 4) a few cases where all members are children -> change to one adult w/ two children 
replace nchild=nchild-1 if fam_size==nchild


* Assign poverty thresholds from the ASEC data to the relevant dem. group in the Monthly CPS
merge m:1 year fam_size nchild head_elderly using pov_thresh
keep if _merge==3
drop _merge


* merge with the imputed family income data 
merge m:1 yr_month asecflag serial using impute
keep if _merge==3
drop _merge

********************************************************************************
* Scale variables
gen scale=((fam_size-nchild+.7*nchild)^.7)

* Construct variables for subgroup analysis 

*1) Full sample
gen gr1=1

*2) Age subgroup
gen gr2= age<18
replace gr2 = 2 if age>=18 & age<65   
replace gr2 = 3 if age>=65

*3) Race subgroup
gen gr3 = race==100             // white   
replace gr3 = 2 if race==200    // black   
replace gr3 = 3 if race!=100 & race!=200  

*4) gender subgroup
gen gr4 = sex==1
replace gr4 = 2 if gr4==0

*5) Education subgroup
*Head's education
bysort yr_month asecflag serial famnum: egen head_hs_less = max(relate==101 & edu<=73)
gen gr5 = head_hs_less==1
replace gr5 = 2 if head_hs_less==0

merge m:1 statefip using st_covid.dta
drop _merge

********************************************************************************
* Missing incomes or CPS-imputed income 
gen miss_inc = (faminc>=995 & faminc<=999)|(qfaminc>0 & qfaminc!=.)

*** Restrict the sample to householder's family 
bysort yr_month asecflag serial famnum: egen hfam = sum(relate==101) 
keep if hfam==1

*** Restrict the sample to individuals in the 5th month interview
keep if mish==5

*** Restrict the sample to individuals with non-imputed income 
keep if miss_inc!=1


********************************************************************************
***  Poverty, Income, Employment variables for 1st and 5th month interview   ***

forvalues n=2/2 {
gen pov`n'= ifam_inc<pov_thresh
gen ifam_inc`n'=ifam_inc
}
replace pov2=. if mish!=5  // 5th month only
replace ifam_inc2=. if mish!=5
merge m:1 yr_month using PCE
keep if _merge==3
drop _merge
** equivalent scale adjustment & 2 adults and 2 children
replace ifam_inc2 = PCE*2.355*ifam_inc2/scale   

********************************************************************************
*************               Calculate Standard Errors              *************


* Full sample
forvalues m = 2/2 {
forvalues i = 1/1 {
forvalues mo = 1/6 {
di `mo'
preserve
keep yr_month serial wtfinl gr* ifam_inc* pov* 
egen ym = group(yr_month)
keep if ym==`mo' & gr`i'==1
local num = `mo'+1

** Poverty Rate
reg pov`m' [w=wtfinl], cluster(serial)
putexcel set App.T5&7.xlsx, sheet(gr1) modify
putexcel A`num' = yr_month
putexcel B`num' = _b[_cons]
putexcel C`num' = _se[_cons]
putexcel D`num' = `e(N)'
putexcel K`num' = `e(N)'

** Income Percentiles
replace wtfinl= round(wtfinl)
qreg2 ifam_inc`m' [w=wtfinl], quantile(.25) 
putexcel H`num' = yr_month
putexcel I`num' = _b[_cons]
putexcel J`num' = _se[_cons]
restore
}
putexcel A1 = "App.T5. Poverty"
putexcel H1 = "App.T7. 25thpct"
}
}


* Subgroup with two categories (GROUP 1)
forvalues m = 2/2 {
forvalues i = 2/5 {
forvalues mo = 1/6 {
di `mo'
preserve
keep yr_month serial wtfinl gr* ifam_inc* pov* 
egen ym = group(yr_month)
keep if ym==`mo' & gr`i'==1
local num = `mo'+1

** Poverty Rate
reg pov`m' [w=wtfinl], cluster(serial)
putexcel set App.T5&7.xlsx, sheet(gr`i') modify
putexcel A`num' = yr_month
putexcel B`num' = _b[_cons]
putexcel C`num' = _se[_cons]

** Income Percentiles
replace wtfinl= round(wtfinl)
qreg2 ifam_inc`m' [w=wtfinl], quantile(.25) 
putexcel H`num' = yr_month
putexcel I`num' = _b[_cons]
putexcel J`num' = _se[_cons]
restore
}
putexcel A1 = "App.T5. Poverty"
putexcel H1 = "App.T7. 25thpct"
}
}

* Subgroup with two categories (GROUP 2)
forvalues m = 2/2 {
forvalues i = 2/5 {
forvalues mo = 1/6 {
di `mo'
preserve
keep yr_month serial wtfinl gr* ifam_inc* pov* 
egen ym = group(yr_month)
keep if ym==`mo' & gr`i'==2
local num = `mo'+1


** Poverty Rate
reg pov`m' [w=wtfinl], cluster(serial)
putexcel set App.T5&7.xlsx, sheet(gr`i') modify
putexcel D`num' = _b[_cons]
putexcel E`num' = _se[_cons]

** Income Percentiles
replace wtfinl= round(wtfinl)
qreg2 ifam_inc`m' [w=wtfinl], quantile(.25) 
putexcel K`num' = _b[_cons]
putexcel L`num' = _se[_cons]
restore
}
putexcel A1 = "App.T5. Poverty"
putexcel H1 = "App.T7. 25thpct"
}
}



* Subgroup with three categories
forvalues m = 2/2 {
foreach i in 2 3 {
forvalues mo = 1/6 {
di `mo'
preserve
keep yr_month serial wtfinl gr* ifam_inc* pov* 
egen ym = group(yr_month)
keep if ym==`mo' & gr`i'==3
local num = `mo'+1


** Poverty Rate
reg pov`m' [w=wtfinl], cluster(serial)
putexcel set App.T5&7.xlsx, sheet(gr`i') modify
putexcel F`num' = _b[_cons]
putexcel G`num' = _se[_cons]

** Income Percentiles
replace wtfinl= round(wtfinl)
qreg2 ifam_inc`m' [w=wtfinl], quantile(.25) 
putexcel M`num' = _b[_cons]
putexcel N`num' = _se[_cons]
restore
}
putexcel A1 = "App.T5. Poverty"
putexcel H1 = "App.T7. 25thpct"
}
}

********************************************************************************
** Pre- vs. Post- COVID19 period
drop if yr_month==202003
replace yr_month=202012 if yr_month==202001|yr_month==202002
replace yr_month=202046 if yr_month==202004|yr_month==202005|yr_month==202006

* Full sample
forvalues m = 2/2 {
forvalues i = 1/1 {
forvalues bimo = 1/2 {
preserve
keep yr_month serial wtfinl gr* ifam_inc* pov* 
egen ym = group(yr_month)
keep if ym==`bimo' & gr`i'==1
local num = `bimo'+7

** Poverty Rate
reg pov`m' [w=wtfinl], cluster(serial)
putexcel set App.T5&7.xlsx, sheet(gr1) modify
putexcel A`num' = yr_month
putexcel B`num' = _b[_cons]
putexcel C`num' = _se[_cons]
putexcel D`num' = `e(N)'
putexcel K`num' = `e(N)'

** Income Percentiles
replace wtfinl= round(wtfinl)
qreg2 ifam_inc`m' [w=wtfinl], quantile(.25) 
putexcel H`num' = yr_month
putexcel I`num' = _b[_cons]
putexcel J`num' = _se[_cons]
restore
}
}
putexcel A1 = "App.T5. Poverty"
putexcel H1 = "App.T7. 25thpct"
}




* Subgroup with two categories (GROUP 1)
forvalues m = 2/2 { 
forvalues i = 2/5 {
forvalues bimo = 1/2 {
preserve
keep yr_month serial wtfinl gr* ifam_inc* pov* 
egen ym = group(yr_month)
keep if ym==`bimo' & gr`i'==1
local num = `bimo'+7

** Poverty Rate
reg pov`m' [w=wtfinl], cluster(serial)
putexcel set App.T5&7.xlsx, sheet(gr`i') modify
putexcel A`num' = yr_month
putexcel B`num' = _b[_cons]
putexcel C`num' = _se[_cons]

** Income Percentiles
replace wtfinl= round(wtfinl)
qreg2 ifam_inc`m' [w=wtfinl], quantile(.25) 
putexcel H`num' = yr_month
putexcel I`num' = _b[_cons]
putexcel J`num' = _se[_cons]
restore
}
putexcel A1 = "App.T5. Poverty"
putexcel H1 = "App.T7. 25thpct"
}
}


* Subgroup with two categories (GROUP 2)
forvalues m = 2/2 { 
forvalues i = 2/5 {
forvalues bimo = 1/2 {
preserve
keep yr_month serial wtfinl gr* ifam_inc* pov* 
egen ym = group(yr_month)
keep if ym==`bimo' & gr`i'==2
local num = `bimo'+7

** Poverty Rate
reg pov`m' [w=wtfinl], cluster(serial)
putexcel set App.T5&7.xlsx, sheet(gr`i') modify
putexcel D`num' = _b[_cons]
putexcel E`num' = _se[_cons]

** Income Percentiles
replace wtfinl= round(wtfinl)
qreg2 ifam_inc`m' [w=wtfinl], quantile(.25) 
putexcel K`num' = _b[_cons]
putexcel L`num' = _se[_cons]
restore
}
putexcel A1 = "App.T5. Poverty"
putexcel H1 = "App.T7. 25thpct"
}
}


* Subgroup with three categories
forvalues m = 2/2 {
foreach i in 2 3 {
forvalues bimo = 1/2 {
preserve
keep yr_month serial wtfinl gr* ifam_inc* pov* 
egen ym = group(yr_month)
keep if ym==`bimo' & gr`i'==3
local num = `bimo'+7

** Poverty Rate
reg pov`m' [w=wtfinl], cluster(serial)
putexcel set App.T5&7.xlsx, sheet(gr`i') modify
putexcel F`num' = _b[_cons]
putexcel G`num' = _se[_cons]

** Income Percentiles
replace wtfinl= round(wtfinl)
qreg2 ifam_inc`m' [w=wtfinl], quantile(.25) 
putexcel M`num' = _b[_cons]
putexcel N`num' = _se[_cons]
restore
}
putexcel A1 = "App.T5. Poverty"
putexcel H1 = "App.T7. 25thpct"
}
}


********************************************************************************
** Appendix Table 5
import excel "`projectfolder'App.T5&7.xlsx", sheet("gr1") cellrange(A1:E9) firstrow clear
forvalues i = 2/5 { 
preserve
import excel "`projectfolder'App.T5&7.xlsx", sheet("gr`i'") cellrange(A1:G9) firstrow clear
foreach var in B C D E F G {
	rename `var' `var'`i'
	}
tempfile gr`i'
save `gr`i''
restore
merge 1:1 AppT5Poverty using `gr`i''
drop _merge
}
xpose, clear
egen miss = rowmiss(_all)
drop if miss>0
drop miss
gen v9 = v8-v7 if _n==2|_n==5|_n==7|_n==9|_n==11|_n==13|_n==15|_n==17|_n==19|_n==21|_n==23
replace v9 = sqrt(v8^2+v7^2) if _n==3|_n==6|_n==8|_n==10|_n==12|_n==14|_n==16|_n==18|_n==20|_n==22|_n==24
drop v7 v8
export excel using App.T5.xlsx, keepcellfmt replace


********************************************************************************
** Appendix Table 7
import excel "`projectfolder'App.T5&7.xlsx", sheet("gr1") cellrange(H1:K9) firstrow clear
forvalues i = 2/3 { 
preserve
import excel "`projectfolder'App.T5&7.xlsx", sheet("gr`i'") cellrange(H1:N9) firstrow clear
foreach var in I J K L M N {
	rename `var' `var'`i'
	}
tempfile gr`i'
save `gr`i''
restore
merge 1:1 AppT725thpct using `gr`i''
drop _merge
}
forvalues i = 4/5 { 
preserve
import excel "`projectfolder'App.T5&7.xlsx", sheet("gr`i'") cellrange(H1:L9) firstrow clear
foreach var in I J K L {
	rename `var' `var'`i'
	}
tempfile gr`i'
save `gr`i''
restore
merge 1:1 AppT725thpct using `gr`i''
drop _merge
}

xpose, clear
egen miss = rowmiss(_all)
drop if miss>0
drop miss

local pointest _n==2|_n==5|_n==7|_n==9|_n==11|_n==13|_n==15|_n==17|_n==19|_n==21|_n==23
local sterr  _n==3|_n==6|_n==8|_n==10|_n==12|_n==14|_n==16|_n==18|_n==20|_n==22|_n==24
gen v9 = v8-v7 if `pointest'
replace v9 = sqrt(v8^2+v7^2) if `sterr'
drop v7 v8
gen id = _n*2
drop if `sterr'
preserve
import excel "`projectfolder'App.T7_BSE.xls", firstrow clear
drop gr
rename (p251 p252 p253 p254 p255 p256 p257) (v1 v2 v3 v4 v5 v6 v9)
gen id = _n*4+4
replace id=6 if id==8
tempfile bse
save `bse'
restore
append using `bse'
sort id
drop id
export excel using App.T7.xlsx, keepcellfmt replace
